function Timer() 
{
	this.TimerObject = null;
	this.Enabled = false;
	this.Interval = 0;
	this.Container = null;
	
	this.TickCallback = null;
	
	this.StartTimer = function() 
	{
		this.TimerObject = window.setTimeout(this.Container + ".Tick()", this.Interval*1000);
	}
				
	this.Tick = function() 
	{
		if ( this.Enabled ) 
		{
			this.TickCallback();
			this.StartTimer();
		}
	}
	
	this.SetInterval = function(newTime) 
	{
		window.clearTimeout(this.TimerObject);
		this.Interval = newTime;
		
		if ( this.Enabled ) 
		{
			this.StartTimer();
		}
	}
	
	this.SetTimerStatus = function(isActive) 
	{
		this.Enabled = isActive;

		if ( this.Enabled ) 
		{
			this.StartTimer();
		} 
		else 
		{
			window.clearTimeout(this.TimerObject);
		}
	}
}

